@description('The SID of the Administrator User for the SQL Server.')
param dbAdminSid string

@description('Prefix used for grouping resources (2-10 characters), e.g. project or product short code')
param prefix string

@description('Environment name that determines the deployment context, e.g. prod, staging, dev')
@minLength(2)
@maxLength(10)
@allowed([
  'prod'
  'staging'
  'dev'
])
param environment string

@description('Geographic region code denoting where these resources belong to, e.g. us, eu. Note that resourceGroupLocation should be set to the actual Azure region.')
@minLength(2)
@maxLength(10)
@allowed([
  'us'
  'eu'
])
param region string

// Identity for SQL Server to run as
resource sqlServerIdentity 'Microsoft.ManagedIdentity/userAssignedIdentities@2023-01-31' = {
  name: '${prefix}-${environment}-${region}-sqlserver-1-identity'
  location: resourceGroup().location
}

// A temporary identity needed to perform specific tasks, this should be deleted later
resource temporaryDeploymentUserAssignedIdentity 'Microsoft.ManagedIdentity/userAssignedIdentities@2023-01-31' = {
  name: '${prefix}-${environment}-${region}-temporary-deployment-identity'
  location: resourceGroup().location
}
