// Some of the same params as before
param dbAdminSid string
param prefix string
param environment string
param region string

// OPTIONAL: This will deploy a minimal ASP.NET App that tries connecting
// to the database using the managed identity.
resource appService 'Microsoft.Web/sites@2024-04-01' existing = {
  name: '${prefix}-${environment}-${region}-appservice-web1'
}

resource appServiceSourceControl 'Microsoft.Web/sites/sourcecontrols@2024-04-01' = {
  parent: appService
  name: 'web'
  properties: {
    repoUrl: 'https://github.com/aduggleby/Samples-AspNetConnectsToSqlWithIdentity'
    branch: 'master'
    isManualIntegration: true
  }
}

resource temporaryDeploymentUserAssignedIdentity 'Microsoft.ManagedIdentity/userAssignedIdentities@2023-01-31' existing = {
  name: '${prefix}-${environment}-${region}-temporary-deployment-identity'
}

resource addTemporaryDeploymentUserToContributorToInitiateSync 'Microsoft.Authorization/roleAssignments@2022-04-01' = {
  name: guid(resourceGroup().id, temporaryDeploymentUserAssignedIdentity.id, 'Contributor')
  properties: {
    principalId: temporaryDeploymentUserAssignedIdentity.properties.principalId
    roleDefinitionId: subscriptionResourceId(
      'Microsoft.Authorization/roleDefinitions',
      'b24988ac-6180-42a0-ab88-20f7382dd24c'
    ) // Contributor role
    principalType: 'ServicePrincipal'
  }
}

// Deployment script to sync the repository
resource appServiceSyncScript 'Microsoft.Resources/deploymentScripts@2020-10-01' = {
  name: 'Initiate_Sync_from_repo_for_${appService.name}'
  location: resourceGroup().location
  kind: 'AzureCLI'
  identity: {
    type: 'UserAssigned'
    userAssignedIdentities: {
      '${temporaryDeploymentUserAssignedIdentity.id}': {}
    }
  }
  properties: {
    azCliVersion: '2.50.0'
    timeout: 'PT30M'
    retentionInterval: 'P1D'
    environmentVariables: [
      {
        name: 'RESOURCEGROUP'
        value: resourceGroup().name
      }
      {
        name: 'APPSERVICE'
        value: appService.name
      }
    ]
    scriptContent: '''
      az webapp deployment source sync \
        --name $APPSERVICE \
        --resource-group $RESOURCEGROUP
    '''
  }
  dependsOn: [
    appServiceSourceControl
  ]
}
